/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.block.HorizontalConnectedBlock;
import cloud.lemonslice.teastory.block.crops.AqueductConnectorBlock;
import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaddyFieldBlock
extends HorizontalConnectedBlock
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Water> WATER = EnumProperty.m_61587_((String)"water", Water.class);
    private static final VoxelShape[] SHAPES;

    public PaddyFieldBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283824_).m_60977_().m_60978_(0.6f).m_60918_(SoundType.f_56740_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(WATER, (Comparable)((Object)Water.SKIP)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Shapes.m_83144_();
        }
        return this.getPaddyFieldShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getPaddyFieldShape(state);
    }

    private VoxelShape getPaddyFieldShape(BlockState state) {
        int north = (Boolean)state.m_61143_((Property)NORTH) != false ? 0 : 8;
        int south = (Boolean)state.m_61143_((Property)SOUTH) != false ? 0 : 4;
        int west = (Boolean)state.m_61143_((Property)WEST) != false ? 0 : 2;
        int east = (Boolean)state.m_61143_((Property)EAST) != false ? 0 : 1;
        return SHAPES[north + south + west + east];
    }

    public boolean m_7361_(LevelAccessor accessor, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    public ItemStack m_142598_(LevelAccessor accessor, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)Items.f_42447_);
    }

    public boolean m_6044_(BlockGetter blockGetter, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean canConnect(BlockState state) {
        return state.m_60734_() instanceof PaddyFieldBlock || state.m_60734_() instanceof AqueductConnectorBlock;
    }

    public BlockState getStateForPlacement(Level world, BlockPos pos) {
        BlockState state = this.m_49966_();
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos facingPos = pos.m_121945_(facing);
            BlockState facingState = world.m_8055_(facingPos);
            if (!this.canConnect(facingState)) continue;
            state = (BlockState)state.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return (BlockState)this.getStateForPlacement(world, pos).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        this.updateWater(worldIn, pos);
    }

    public void updateWater(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this) {
            boolean hasWater = (Boolean)state.m_61143_((Property)WATERLOGGED);
            Water trend = (Water)((Object)state.m_61143_(WATER));
            if (trend != Water.SKIP) {
                if (trend == Water.POUR) {
                    if (!hasWater) {
                        world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_(WATER, (Comparable)((Object)Water.SKIP)), 3);
                        this.setToUpdate(world, pos.m_122012_(), trend);
                        this.setToUpdate(world, pos.m_122019_(), trend);
                        this.setToUpdate(world, pos.m_122024_(), trend);
                        this.setToUpdate(world, pos.m_122029_(), trend);
                    }
                } else if (hasWater) {
                    world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(WATER, (Comparable)((Object)Water.SKIP)), 3);
                    this.setToUpdate(world, pos.m_122012_(), trend);
                    this.setToUpdate(world, pos.m_122019_(), trend);
                    this.setToUpdate(world, pos.m_122024_(), trend);
                    this.setToUpdate(world, pos.m_122029_(), trend);
                }
            }
        }
    }

    public void setToUpdate(ServerLevel world, BlockPos pos, Water water) {
        if (water == Water.SKIP) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this) {
            if (water == Water.POUR && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_(WATER, (Comparable)((Object)water)), 3);
                world.m_186460_(pos, (Block)this, Fluids.f_76193_.m_6718_((LevelReader)world) + 1);
            } else if (water == Water.DRAIN && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_(WATER, (Comparable)((Object)water)), 3);
                world.m_186460_(pos, (Block)this, Fluids.f_76193_.m_6718_((LevelReader)world));
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL) {
            return (BlockState)stateIn.m_61124_((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canConnect(facingState)));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.m_5707_(level, pos, state, player);
        return level.m_7731_(pos, Blocks.f_50016_.m_49966_(), level.m_5776_() ? 11 : 3);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{WATERLOGGED, WATER}));
    }

    public boolean isFertile(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    static {
        VoxelShape BOTTOM = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 6.0, 16.0);
        VoxelShape WALL_NORTH = VoxelShapeHelper.createVoxelShape(0.0, 6.0, 0.0, 16.0, 10.0, 3.0);
        VoxelShape WALL_SOUTH = VoxelShapeHelper.createVoxelShape(0.0, 6.0, 13.0, 16.0, 10.0, 3.0);
        VoxelShape WALL_WEST = VoxelShapeHelper.createVoxelShape(0.0, 6.0, 0.0, 3.0, 10.0, 16.0);
        VoxelShape WALL_EAST = VoxelShapeHelper.createVoxelShape(13.0, 6.0, 0.0, 3.0, 10.0, 16.0);
        SHAPES = new VoxelShape[]{BOTTOM, Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)WALL_EAST).m_83296_(), Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)WALL_WEST).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST}).m_83296_(), Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)WALL_SOUTH).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH}).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH}).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH}).m_83296_(), Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)WALL_NORTH).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_EAST, WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_SOUTH, WALL_NORTH}).m_83296_(), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{WALL_WEST, WALL_EAST, WALL_SOUTH, WALL_NORTH}).m_83296_()};
    }

    public static enum Water implements StringRepresentable
    {
        SKIP("skip"),
        DRAIN("darin"),
        POUR("pour");

        private final String name;

        private Water(String s) {
            this.name = s;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

